<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

 <xsl:output 
  method='xml'
  omit-xml-declaration='no'
  indent='yes'
  doctype-public='-//W3C//DTD XHTML 1.0 Transitional//EN' 
  doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd' />
  
 <xsl:template match='TEI.2'>
  <html>
  
   <head>
 
    <!-- title tag -->
    <title> 
     <xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/title)' /> / <xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/author)' />
    </title> 
 
    <!-- id -->
    <meta>
     <xsl:attribute name='name'>identifier</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/idno/@type)' /><xsl:text>-</xsl:text><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/idno)' /></xsl:attribute>
    </meta>
 
    <!-- author -->
    <meta>
     <xsl:attribute name='name'>author</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/author)' /></xsl:attribute>
    </meta>
 
    <!-- title tag, again -->
    <meta>
     <xsl:attribute name='name'>title</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/title)' /></xsl:attribute>
    </meta>
 
    <!-- date -->
    <meta>
     <xsl:attribute name='name'>date</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/profileDesc/creation/date)' /></xsl:attribute>
    </meta>
 
    <!-- publisher -->
    <meta>
     <xsl:attribute name='name'>publisher</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/publisher)' /></xsl:attribute>
    </meta>
  
    <!-- source -->
    <meta>
     <xsl:attribute name='name'>source</xsl:attribute>
     <xsl:attribute name='content'>
      <xsl:for-each select="/TEI.2/teiHeader/fileDesc/sourceDesc/p"><xsl:value-of select='normalize-space(.)'/> </xsl:for-each>
     </xsl:attribute>
    </meta>
 
    <!-- notes -->
    <meta>
     <xsl:attribute name='name'>description</xsl:attribute>
     <xsl:attribute name='content'>
      <xsl:for-each select="/TEI.2/teiHeader/fileDesc/notesStmt/note"><xsl:value-of select='normalize-space(.)'/> </xsl:for-each>
     </xsl:attribute>
    </meta>
 
    <!-- rights -->
    <meta>
     <xsl:attribute name='name'>rights</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/availability/p)' /></xsl:attribute>
    </meta>
        
    <!-- relation -->
    <meta>
     <xsl:attribute name='name'>relation</xsl:attribute>
     <xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/distributor/xptr/@url)' /></xsl:attribute>
    </meta>
        
    <!-- subjects -->
    <meta>
     <xsl:attribute name='name'>subject</xsl:attribute>
     <xsl:attribute name='content'>
       <xsl:for-each select='teiHeader/profileDesc/textClass/keywords/list/item'>
       <xsl:value-of select='normalize-space(.)' />
       <xsl:text>; </xsl:text>
       </xsl:for-each>
     </xsl:attribute>
    </meta>
        
    <!-- stylesheet -->
    <link>
     <xsl:attribute name='rel'>stylesheet</xsl:attribute>
     <xsl:attribute name='href'>/musings/etc/musings.css</xsl:attribute>
     <xsl:attribute name='type'>text/css</xsl:attribute>
      <xsl:attribute name='media'>screen</xsl:attribute>
    </link>  
    <link>
     <xsl:attribute name='rel'>stylesheet</xsl:attribute>
     <xsl:attribute name='href'>/musings/etc/musings-print.css</xsl:attribute>
     <xsl:attribute name='type'>text/css</xsl:attribute>
      <xsl:attribute name='media'>print</xsl:attribute>
    </link>  
  
  </head>
   
   <body>
    
    <!-- ssi gobal navigation bar -->
    <xsl:comment>#include virtual="/musings/etc/navigation.inc"</xsl:comment>
    
    <!-- ssi local menu -->
    <xsl:comment>#include virtual="/musings/etc/contents.inc"</xsl:comment>
    
    <!-- content -->
    <div class='content'>
    
     <!-- title -->
     <h1><xsl:value-of select='teiHeader/fileDesc/titleStmt/title' /></h1>
     
     <!-- do the heavy lifting -->
     <xsl:apply-templates/>   
   
    </div>
    
    <!-- footer -->
 
<div class='footer'>
	<p>
			<b><xsl:text>Author: </xsl:text></b>
			<xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/author)' />
			<xsl:text> &lt;</xsl:text><a><xsl:attribute name='href'><xsl:text>mailto:</xsl:text><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/address/addrLine)' /></xsl:attribute><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/address/addrLine)' /></a><xsl:text>&gt;</xsl:text>
		<br />
			<b><xsl:text>Source: </xsl:text></b>
			<xsl:value-of select='teiHeader/fileDesc/sourceDesc/p' />
		<br />
			<b><xsl:text>Date created: </xsl:text></b>
			<xsl:value-of select='normalize-space(teiHeader/profileDesc/creation/date)' />
		<br />
			<b><xsl:text>Date updated: </xsl:text></b>
			<xsl:value-of select='normalize-space(teiHeader/revisionDesc/change/date)' />
		<br />
<b><xsl:text>Subject(s): </xsl:text></b><xsl:for-each select='teiHeader/profileDesc/textClass/keywords/list/item'><a><xsl:attribute name='href'><xsl:text>../?cmd=search&amp;query=subject%3D</xsl:text><xsl:call-template name='search-and-replace'><xsl:with-param name='input' select='normalize-space(.)' /><xsl:with-param name='search-string' select='" "' /><xsl:with-param name='replace-string' select='"%20"' /></xsl:call-template></xsl:attribute><xsl:value-of select='normalize-space(.)' /></a><xsl:text>; </xsl:text></xsl:for-each>
		<br />
			<b><xsl:text>XML source: </xsl:text></b>
			<a><xsl:attribute name='href'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/distributor/xptr/@url)' /></xsl:attribute><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/distributor/xptr/@url)' /></a>
	</p>
</div>

   </body>
   
  </html>
  
 </xsl:template>
 
 <!-- division #1 (div1) -->
 <xsl:template match="div1">
  <h2><xsl:value-of select='./head' /></h2>
  <xsl:apply-templates />
 </xsl:template>

 <!-- division #2 (div2) -->
 <xsl:template match="div2">
  <h3><xsl:value-of select='./head' /></h3>
  <xsl:apply-templates />
 </xsl:template>

 <!-- division #3 (div3) -->
 <xsl:template match="div3">
  <h4><xsl:value-of select='./head' /></h4>
  <xsl:apply-templates />
 </xsl:template>

 <!-- division #4 (div4) -->
 <xsl:template match="div4">
  <h5><xsl:value-of select='./head' /></h5>
  <xsl:apply-templates />
 </xsl:template>

 <!-- division #5 (div5) -->
 <xsl:template match="div5">
  <h6><xsl:value-of select='./head' /></h6>
  <xsl:apply-templates />
 </xsl:template>

 <!-- paragraph (p) -->
 <xsl:template match="p">
  <xsl:choose>
  <xsl:when test='./@rend = "right"'>
   <p style='text-align:right'><xsl:apply-templates /></p>
  </xsl:when>
  <xsl:when test='./@rend = "center"'>
   <p style='text-align:center'><xsl:apply-templates /></p>
  </xsl:when>
  <xsl:when test='./@rend = "fiction"'>
   <p class='fiction'><xsl:text>&#160;&#160;&#160;&#160;</xsl:text><xsl:apply-templates /></p>
  </xsl:when>
  <xsl:when test='./@rend = "pre"'>
   <pre><xsl:apply-templates /></pre>
  </xsl:when>
  <xsl:otherwise>
   <p><xsl:apply-templates /></p>
  </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <!-- quote (quote) -->
 <xsl:template match="quote">
  <blockquote><xsl:apply-templates /></blockquote>
 </xsl:template>

 <!-- line group (lg) -->
 <xsl:template match="lg">
  <p><xsl:apply-templates /></p>
 </xsl:template>

 <!-- line (l) -->
 <xsl:template match="l">
  <xsl:apply-templates /><br />
 </xsl:template>


<!-- hypertext reference (xref) -->
 <xsl:template match="xref">
 <a><xsl:attribute name='href'><xsl:value-of select='./@url' /></xsl:attribute><xsl:apply-templates /></a>
 </xsl:template>

<!-- hypertext reference (xptr) -->
 <xsl:template match="xptr">
 <a><xsl:attribute name='href'><xsl:value-of select='./@url' /></xsl:attribute><xsl:value-of select='./@url' /></a>
 </xsl:template>
 
 <!-- table (table) -->
 
<xsl:template match="table">
	<xsl:choose>
		<xsl:when test='./@rend = "left"'>
<table><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></table>		</xsl:when>
		<xsl:when test='./@rend = "right"'>
<table><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></table>		</xsl:when>
		<xsl:when test='./@rend = "center"'>
<table><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></table>		</xsl:when>
		<xsl:otherwise>
<table><xsl:attribute name='border'>1</xsl:attribute><xsl:apply-templates /></table>		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

 <!-- table row (row) -->
<xsl:template match="row">
	<xsl:choose>
		<xsl:when test='./@rend = "left"'>
<tr><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:attribute name='valign'><xsl:text>top</xsl:text></xsl:attribute><xsl:apply-templates /></tr>		</xsl:when>
		<xsl:when test='./@rend = "right"'>
<tr><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:attribute name='valign'><xsl:text>top</xsl:text></xsl:attribute><xsl:apply-templates /></tr>		</xsl:when>
		<xsl:when test='./@rend = "center"'>
<tr><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:attribute name='valign'><xsl:text>top</xsl:text></xsl:attribute><xsl:apply-templates /></tr>		</xsl:when>
		<xsl:when test='./@rend = "justify"'>
<tr><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:attribute name='valign'><xsl:text>top</xsl:text></xsl:attribute><xsl:apply-templates /></tr>		</xsl:when>
		<xsl:otherwise>
<tr><xsl:attribute name='valign'><xsl:text>top</xsl:text></xsl:attribute><xsl:apply-templates /></tr>		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


 <!-- table row (cell) -->
<xsl:template match="cell">
	<xsl:choose>
		<xsl:when test='./@rend = "left"'>
<td><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></td>		</xsl:when>
		<xsl:when test='./@rend = "right"'>
<td><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></td>		</xsl:when>
		<xsl:when test='./@rend = "center"'>
<td><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></td>		</xsl:when>
		<xsl:when test='./@rend = "justify"'>
<td><xsl:attribute name='align'><xsl:value-of select='@rend' /></xsl:attribute><xsl:apply-templates /></td>		</xsl:when>
		<xsl:otherwise>
<td><xsl:apply-templates /></td>		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


 <!-- images (figure) -->
  <xsl:template match="figure">
  <img>
  	<xsl:attribute name='src'><xsl:value-of select='./@url' /></xsl:attribute>
  	<xsl:choose>
  	<xsl:when test='./figDesc'>
		<xsl:attribute name='alt'><xsl:value-of select='normalize-space(./figDesc)' /></xsl:attribute>
	</xsl:when>
  	<xsl:otherwise>
  			<xsl:attribute name='alt'><xsl:value-of select='./@url' /></xsl:attribute>
  	</xsl:otherwise>
  	</xsl:choose>
  	<xsl:choose>
  		<xsl:when test='./@rend = "top"'>
  		<xsl:attribute name='align'><xsl:value-of select='./@rend' /></xsl:attribute>
  		</xsl:when>
 		<xsl:when test='./@rend = "middle"'>
  		<xsl:attribute name='align'><xsl:value-of select='./@rend' /></xsl:attribute>
  		</xsl:when>
 		<xsl:when test='./@rend = "bottom"'>
  		<xsl:attribute name='align'><xsl:value-of select='./@rend' /></xsl:attribute>
  		</xsl:when>
 		<xsl:when test='./@rend = "left"'>
  		<xsl:attribute name='align'><xsl:value-of select='./@rend' /></xsl:attribute>
  		</xsl:when>
 		<xsl:when test='./@rend = "right"'>
  		<xsl:attribute name='align'><xsl:value-of select='./@rend' /></xsl:attribute>
  		</xsl:when>
  		<xsl:otherwise />
  	</xsl:choose>
  </img>
  <xsl:apply-templates/>
 </xsl:template>

<xsl:template match='lb'>
<br /><xsl:apply-templates />
</xsl:template>

<xsl:template match='figDesc'>
<span class='caption'><xsl:apply-templates/></span>
</xsl:template>

<xsl:template match='lg'>
	<xsl:choose>
		<xsl:when test='./@rend="indent"'>
			<div class='lg_indent'>
				<xsl:apply-templates />
			</div>
		</xsl:when>
		<xsl:otherwise>
			<div class='lg'>
				<xsl:apply-templates />
			</div>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match='l'>
	<xsl:choose>
		<xsl:when test='./@rend="indent"'>
			<span class='line_indent'>
				<xsl:apply-templates />
			</span> 
		</xsl:when>
		<xsl:otherwise>
			<span class='line'>
				<xsl:apply-templates />
			</span> 
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- find and replace (from XSLT Cookbook by Sal Mangano, pg. 13 -->
<xsl:template name='search-and-replace'>
	<xsl:param name='input'/>
	<xsl:param name='search-string'/>
	<xsl:param name='replace-string'/>
	<xsl:choose>
		<xsl:when test='$search-string and contains($input,$search-string)'>
			<xsl:value-of select='substring-before($input,$search-string)'/>
			<xsl:value-of select='$replace-string'/>
			<xsl:call-template name='search-and-replace'>
				<xsl:with-param name='input' select='substring-after($input,$search-string)'/>
				<xsl:with-param name='search-string' select='$search-string'/>
				<xsl:with-param name='replace-string' select='$replace-string'/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select='$input'/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
 

<!-- lists -->
<!-- cool XPath expressions and logic by bodard gabriel <gabriel.bodard@kcl.ac.uk> -->
<xsl:template match="list[@type='gloss']">
  <dl>
    <xsl:apply-templates/>
  </dl>
</xsl:template>

<xsl:template match="list[@type='ordered']">
  <ol>
    <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="list[@type='bulleted']">
  <ul>
    <xsl:apply-templates/>
  </ul>
</xsl:template>

<xsl:template match="label[parent::list[@type='gloss']]">
  <dt>
    <xsl:apply-templates/>
  </dt>
</xsl:template>

<xsl:template match="item[parent::list[@type='gloss']]">
  <dd>
    <xsl:apply-templates/>
  </dd>
</xsl:template>

<xsl:template match="item[parent::list[@type='bulleted']]">
  <li>
    <xsl:apply-templates/>
  </li>
</xsl:template>

<xsl:template match="item[parent::list[@type='ordered']]">
  <li>
    <xsl:apply-templates/>
  </li>
</xsl:template>


<xsl:template match='persName'>
<span class='persName'><xsl:apply-templates /></span>
</xsl:template>

 <!-- do nothing templates -->

 <!-- teiheader (do nothing) -->
 <xsl:template match="teiHeader" />
 
 <!-- head (head) -->
 <xsl:template match="head" />

</xsl:stylesheet>
