#!/usr/bin/perl

# stylesheets.cgi - a Web interface for managing Musings stylesheet terms

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-10-31 - first cust


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use Musings::Stylesheet;
use strict;
require 'subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;
my $html;

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')  { &create }
elsif ($cgi->param('cmd') eq 'find') { &find }
elsif ($cgi->param('cmd') eq 'edit')    { &edit }
elsif ($cgi->param('cmd') eq 'delete')  { &delete }
else { $html = $cgi->p("Unknown command. Call Eric") }

# quit
&gracefulExit;


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage stylesheets');
	$html .= $cgi->p('Use this script to create, edit, and delete Musings stylesheets.');

}


sub create {

	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# build the form
		$html .= $cgi->p('Use this form to create a stylesheet.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['Name', $cgi->textfield(-name => 'name')]),
							td(['Note', $cgi->textarea(-name => 'note')]),
							td(['Content', $cgi->textarea(-name => 'content', -rows => 12, -columns => 50)]),
							td([''    , $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $stylesheet = Musings::Stylesheet->new;
    	$stylesheet->stylesheet_name($cgi->param('name'));
    	$stylesheet->stylesheet_note($cgi->param('note'));
    	$stylesheet->stylesheet_content($cgi->param('content'));
		$stylesheet->commit;
				
		# echo the results
		$html .= $cgi->p('Stylesheet created:');
		$html .= $cgi->ul(li('ID -', $stylesheet->stylesheet_id),
		                  li('Name - ', $stylesheet->stylesheet_name),
		                  li('Note - ', $stylesheet->stylesheet_note),
		                  li('Content - ', $stylesheet->stylesheet_content)
		                 );
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All stylesheets');
	$html .= $cgi->p('This is a list of all the stylesheets:');
	
	# get all the stylesheets, build a list, and display it
	my @stylesheets = Musings::Stylesheet->get_stylesheets();
	my $items;
	foreach (@stylesheets) { $items .= $cgi->li($_->stylesheet_name, ' (' . $_->stylesheet_id . ') - ', $_->stylesheet_note) }
	$html .= $cgi->ul($items);
	
}


sub edit {

	# initialize the output and a button
	$html = $cgi->h1('Edit stylesheets');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Edit');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of stylesheets; needs to be sorted
		my @stylesheets = Musings::Stylesheet->get_stylesheets;
		my %stylesheets;
		foreach (@stylesheets) { $stylesheets{$_->stylesheet_id} = $_->stylesheet_name }
	
		# display a form
		$html .= $cgi->p('Select a stylesheet to edit');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%stylesheets);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	elsif (! $cgi->param('name') || ! $cgi->param('content')) {
	
    	# create an object based on the input, and create form parts
    	my $stylesheet = Musings::Stylesheet->new(id => $cgi->param('id'));
    	
		# display an edit form
		$html .= $cgi->p('Use this form to edit a stylesheet.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $stylesheet->stylesheet_id);
		$html .= table({-border => 0},
					Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['ID'  , $stylesheet->stylesheet_id]),
							td(['Name', $cgi->textfield(-name => 'name', -value => $stylesheet->stylesheet_name)]),
							td(['Note', $cgi->textarea(-name => 'note', -value => $stylesheet->stylesheet_note)]),
							td(['Content', $cgi->textarea(-name => 'content', -value => $stylesheet->stylesheet_content, -rows => 12, -columns => 50)]),
							td([''    , $submit])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
	else {

		# create and object, fill it, and save
		my $stylesheet = Musings::Stylesheet->new(id => $cgi->param('id'));
		$stylesheet->stylesheet_name($cgi->param('name'));
		$stylesheet->stylesheet_note($cgi->param('note'));
		$stylesheet->stylesheet_content($cgi->param('content'));
		$stylesheet->commit;
		
		# echo the result
		$html .= $cgi->p('Stylesheet updated.');
		$html .= $cgi->p('ID:', $stylesheet->stylesheet_id, '<br />Name:', $stylesheet->stylesheet_name, '<br />Note:' , $stylesheet->stylesheet_note, '<br />Content:', $cgi->pre(&escape($stylesheet->stylesheet_content)));
    
    }

}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete stylesheets');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# build of hash of all stylesheets; needs to be sorted
		my @stylesheets = Musings::Stylesheet->get_stylesheets;
		my %stylesheets;
		foreach (@stylesheets) { $stylesheets{$_->stylesheet_id} = $_->stylesheet_name }

		# display a pop-up list of stylesheets
		$html .= $cgi->p('Select a stylesheet to delete:');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%stylesheets);
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $stylesheet = Musings::Stylesheet->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the stylesheet named <b>' . $stylesheet->stylesheet_name . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $stylesheet->stylesheet_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete the stylesheet; do the work and echo the result
    	my $stylesheet = Musings::Stylesheet->new(id => $cgi->param('id'));
    	$stylesheet->delete;
    	$html .= $cgi->p('The stylesheet ' . $stylesheet->stylesheet_name . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $stylesheet = Musings::Stylesheet->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The stylesheet ' . $stylesheet->stylesheet_name . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}


sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Manage stylesheets</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi">Home</a></li>
				<li><a href="authors.cgi">Authors</a></li>
				<li><a href="stylesheets.cgi">Subjects</a></li>
				<li><a href="templates.cgi">Templates</a></li>
				<li><a href="stylesheets.cgi" id="current">Stylesheets</a></li>
				<li><a href="articles.cgi">Articles</a></li>
			</ul>
		</div>
	
		<div class='menu'>
			<p><b><a href="$script">Manage stylesheets</a></b></p>
			<a href="$script?cmd=create">Create</a><br />
			<a href="$script?cmd=find">Find all</a><br />
			<a href="$script?cmd=edit">Edit</a><br />
			<a href="$script?cmd=delete">Delete</a><br />
			<br />
		</div>
		
		<div class='content'>
EOH

}
