#!/usr/bin/perl

# make-musings-oai.pl - create a set of OAI files from the musings database

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-11-07 - first cut

use constant OAIROOT => '/usr/local/apache/htdocs/musings/oai/data/';
use constant WEBROOT => 'http://infomotions.com';
use Musings::Article;
use Musings::Subject;
use strict;

my @articles = Musings::Article->get_articles;
foreach (@articles) {
	
	my $date        = $_->article_date;
	my $description = &escape($_->article_note);
	my $relation    = WEBROOT . $_->article_path . $_->article_filename;
	my $source      = &escape($_->article_source);
	my $title       = &escape($_->article_title);
	my $url         = WEBROOT . $_->article_path;
	my @subject_ids = $_->subject_ids;
	my $subjects;
	foreach (@subject_ids) {
	
		my $subject = Musings::Subject->new(id =>$_);
		$subjects .= '<subject>' . &escape($subject->subject_term) . '</subject>';
	
	}
	
	open (OAI, '> ' . OAIROOT . 'musings-' . $_->article_id . '.xml');
	print OAI <<EOR;
<?xml version="1.0" encoding="UTF-8"?>

<oaidc:dc xmlns="http://purl.org/dc/elements/1.1/" 
	xmlns:oaidc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
	http://www.openarchives.org/OAI/2.0/oai_dc.xsd">
				  
	<creator>Eric Lease Morgan</creator>
	<date>$date</date>
	<title>$title</title>
	<description>$description</description>
	$subjects
	<relation>TEI/XML source for this document is available at $relation</relation>
	<rights>This text is distributed under the GNU Public License.</rights>
	<source>$source</source>

	<identifier>$url</identifier>
	<publisher>Infomotions, Inc.</publisher>
	<type>text</type>
	<language>en-US</language>
	<format>text/html</format>

</oaidc:dc>
EOR

	close OAI;
	
}


sub escape {

    my $text = shift;
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    return($text);
    
}


