<?xml version='1.0'?>
<xsl:stylesheet xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:srw_dc="info:srw/schema/1/dc-v1.1" xmlns:srw="http://www.loc.gov/zing/srw/" xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>
    <xsl:output method='html' omit-xml-declaration='yes' />
    <!-- let's get started -->
    <xsl:template match='/'>
        <html>
            <head>
                <title>Simple SRU client search results</title>
                <link type="text/css" rel="stylesheet" href="/simple/style.css" />
            </head>
            <body>
                <h1>Simple SRU client search results</h1>
                
                <!-- suggestions -->
                <xsl:if test="(srw:searchRetrieveResponse/srw:extraResponseData/srw:spellset/srw:spell/srw:count &gt; 0) or (srw:searchRetrieveResponse/srw:extraResponseData/srw:synonymset/srw:synonym/srw:count &gt; 0)">
                    <div class="otherSearches">
                        
                        <!-- alternative spellings -->
                        <xsl:if test="srw:searchRetrieveResponse/srw:extraResponseData/srw:spellset/srw:spell/srw:count &gt; 0">
                            <p style='font-size: small'>
                                <span style='font-weight: bold'>Alternative spellings: </span>
                                <xsl:for-each select='srw:searchRetrieveResponse/srw:extraResponseData/srw:spellset/srw:spell/srw:suggestions/srw:suggestion'>
                                    <xsl:value-of select='.' />
                                    <xsl:text>; </xsl:text>
                                </xsl:for-each>
                            </p>
                        </xsl:if>
                        
                        <!-- synonymos -->
                        <xsl:if test="srw:searchRetrieveResponse/srw:extraResponseData/srw:synonymset/srw:synonym/srw:count &gt; 0">
                            <p style='font-size: small'>
                                <span style='font-weight: bold'>Possible synonyms: </span>
                                <xsl:for-each select='srw:searchRetrieveResponse/srw:extraResponseData/srw:synonymset/srw:synonym/srw:suggestions/srw:suggestion'>
                                    <xsl:value-of select='.' />
                                    <xsl:text>; </xsl:text>
                                </xsl:for-each>
                            </p>
                        </xsl:if>
                    </div>
                </xsl:if>
                
                <!-- echo the query and number of hits returned -->
                <p>
                    <xsl:text>Your search (</xsl:text>
                    <xsl:value-of select='srw:searchRetrieveResponse/srw:echoedSearchRetrieveRequest/srw:query' />
                    <xsl:text>) matched </xsl:text>
                    <xsl:value-of select='srw:searchRetrieveResponse/srw:numberOfRecords' />
                    <xsl:text> record(s).</xsl:text>
                </p>
                
                <!-- list the records -->
                <ol>
                    <xsl:for-each select='//srw_dc:dc'>
                        <li class='record'>
                            <a>
                                <xsl:attribute name='href'>
                                    <xsl:value-of select='dc:identifier' />
                                </xsl:attribute>
                                <xsl:value-of select='dc:title' />
                            </a>
                            <ul class='detaillist'>
                                <li>
                                <span class='bold'>creator</span> - 
                                <xsl:value-of select='dc:creator' /></li>
                                <li>
                                <span class='bold'>location</span> - 
                                <a>
                                    <xsl:attribute name='href'>
                                        <xsl:value-of select='dc:identifier' />
                                    </xsl:attribute>
                                    <xsl:value-of select='dc:identifier' />
                                </a></li>
                                <li>
                                <span class='bold'>description</span> - 
                                <xsl:value-of select='dc:description' /></li>
                            </ul>
                        </li>
                    </xsl:for-each>
                </ol>
                
                <!-- done -->
		        <hr />
				<p class='footer'>Author: Eric Lease Morgan 
				&lt;<a href="mailto:emorgan@nd.edu">emorgan@nd.edu</a>&gt; 
				<br />Date created: August 5, 2005 
				<br />Date updated: Februrary 22, 2006 
				<br />URL: 
				<a href='http://dewey.library.nd.edu/morgan/zagreb/sru/'>http://dewey.library.nd.edu/morgan/zagreb/sru/</a></p>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
