#!/usr/bin/perl

# admin.cgi - a menu interface to MyLibrary administration

# Eric Lease Morgan <emorgan@nd.edu>
# January 27, 2006 - moving to the MyLibrary distro

=head1 NAME

admin.cgi - the home page of this MyLibrary administrative interface


=head1 DESCRIPTION

This is the home page of the MyLibrary administrative interface. You are expected to symbolically link it to a file named index.cgi:

  ln -s admin.cgi index.cgi

The file really only acts as a menuing program. It has no other functionality, and it requires no configuration.

=head1 AUTHOR

Eric Lease Morgan

=cut

# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use strict;
use MyLibrary::Core;
require 'etc/subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;

# output the 'magic line', a standard header, the content, and a standard footer, then done
print $cgi->header;
print &header;
print $cgi->h1('MyLibrary Portal administration');
print $cgi->p('Use this system to manage the MyLibrary Portal content.');
print &footer;
exit;



sub header {
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>MyLibrary Portal administration</title>
		<link rel='stylesheet' href='../etc/portal-screen.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="admin.cgi" id="current">Home</a></li>
				<li><a href="facets.cgi">Facets</a></li>
				<li><a href="terms.cgi">Terms</a></li>
				<li><a href="location-types.cgi">Location types</a></li>
				<li><a href="resources.cgi">Resources</a></li>
				<li><a href="patrons.cgi">Patrons</a></li>
			</ul>
		</div>
	
	<div class='menu'>
	</div>
	<div class='content'>
EOH

}
