#!/usr/bin/perl

# fathom.pl - given a text file, output quick & dirty readability scores

# Eric Lease Morgan <emorgan@nd.edu>
# April 10, 2015 - a hack for THATCamp 2015 at Notre Dame; blatantly stolen from Fathom.pm


# require
use strict;
use Lingua::EN::Fathom;

# sanity check
my $file = $ARGV[ 0 ];
if ( ! $file ) {

	print "Usage: $0 <file>\n";
	exit;
	
}

# initialize
my $text = Lingua::EN::Fathom->new;
$text->analyse_file( $file );
my $accumulate  = 1;
my $text_string = '';

# do the work
$text->analyse_block( $text_string, $accumulate );

# echo
my $num_chars             = $text->num_chars;
my $num_words             = $text->num_words;
my $percent_complex_words = $text->percent_complex_words;
my $num_sentences         = $text->num_sentences;
my $num_text_lines        = $text->num_text_lines;
my $num_blank_lines       = $text->num_blank_lines;
my $num_paragraphs        = $text->num_paragraphs;
my $syllables_per_word    = $text->syllables_per_word;
my $words_per_sentence    = $text->words_per_sentence;

my %words = $text->unique_words;
foreach my $word ( sort keys %words ) { print( "$words{$word}\t$word\n" ) }

my $fog     = $text->fog;
my $flesch  = $text->flesch;
my $kincaid = $text->kincaid;

print($text->report);