#!/usr/bin/perl

# make-home.pl - create home page of Infomotions image gallery

# Eric Lease Morgan <eric_morgan@infomotions.com>
# May 15, 2010 - first investigations
# May 17, 2010 - started including tags, not just sets
# May 22, 2010 - added random images to template


# require
use CGI;
use LWP::UserAgent;
use strict;
use XML::XPath;

# configure
use constant GETLISTUSERPOPULAR => 'http://api.flickr.com/services/rest/?method=flickr.tags.getListUserPopular&api_key=50e083708380c01d75fb123fec320365&count=100&user_id=94959848@N00';
use constant GETLIST            => 'http://api.flickr.com/services/rest/?method=flickr.photosets.getList&api_key=50e083708380c01d75fb123fec320365&user_id=94959848@N00';

# get my tags
my $ua          = LWP::UserAgent->new;
my $request     = HTTP::Request->new( GET => GETLISTUSERPOPULAR );
my $response    = $ua->request( $request );

# build a list of all tags
my $parser = XML::XPath->new( xml => $response->content );
my $nodes  = $parser->find( '//tag' );
my %tags   = ();
foreach my $node ( $nodes->get_nodelist ) { $tags{ $node->string_value } = $node->getAttribute( 'count' ) }

# create formatted list of tags
my $taglist = '';
my $cgi     = CGI->new;
foreach ( sort { $tags{ $b } <=> $tags{ $a } } keys %tags ) {

	my $tag    = $_;
	my $count  = $tags{ $tag };
	$taglist  .= $cgi->a({ href => "$tag/" }, $tag ) . $cgi->span({ style => 'color: silver' }, '&#xA0;(' . $count . ')' ) . '&#xA0;&#x2022; ';	

}

# build a list of all sets
$ua       = LWP::UserAgent->new;
$request  = HTTP::Request->new( GET => GETLIST );
$response = $ua->request( $request );
$parser   = XML::XPath->new( xml => $response->content );
my $nodes = $parser->find( '//photoset' );
my %sets  = ();
foreach my $node ( $nodes->get_nodelist ) {

	# build list of sets
	my $id    = $node->getAttribute( 'id' );
	my $title = $node->findvalue( 'title' );
	my $count = $node->getAttribute( 'photos' );
	$sets{ $id } = "$count\t$title";
	
}

# create formatted list of sets
my $setlist = '';
foreach ( sort { $sets{ $b } <=> $sets{ $a } } keys %sets ) {

	my $set = $_;
	my ( $count, $title ) = split /\t/, $sets{ $set };
	$setlist .= $cgi->a({ href => "$set/" }, $title ) . $cgi->span({ style => 'color: silver' }, '&#xA0;(' . $count . ')' ) . '&#xA0;&#x2022; ';

}


# build html
my $html =  &template;
$html    =~ s/##SETLIST##/$setlist/;
$html    =~ s/##TAGLIST##/$taglist/;

# done
print $html;
exit;


sub template {

	# shape of html page
	return <<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/jquery-ui.css" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/screen.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/print.css" media="print" />
	<title>Infomotions Image Gallery</title>
</head>
<body>

	<!-- global navigation; menu bar -->
	<div id="menu" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
		
			<ul id="tabs" class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
				<li id='first-tab' class="ui-state-default ui-corner-top"><a href="/">Home</a>
				<li class="ui-state-default ui-corner-top"><a href="/alex/">Alex Catalogue</a>
				<li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/images/">Images</a>
				<li class="ui-state-default ui-corner-top"><a href="/blog/">Blog</a>
				<li class="ui-state-default ui-corner-top"><a href="/musings/">Musings</a>
				<li class="ui-state-default ui-corner-top"><a href="/water/index.xml">Water</a>
				<li class="ui-state-default ui-corner-top"><a href="http://m.infomotions.com/">iMobile</a>
			</ul>
				
	</div>
		
	<!-- navigation -->
	<div id='navigation'>
		<div class='innertube'>
		
                <!-- logo and short -->
                <p id='navigation-logo'><img src='/logo.gif' width="44" height="44" alt='logo' /><br />
                <br />Image Gallery</p>
                
		</div>
	</div>
        
	<!-- content -->
	<div id='content'>
		<div class='innertube'>
		<h1>Infomotions Image Gallery</h1>
		
		<h2>Tags</h2>
		<p style='text-align: center; margin-left: 3em; margin-right: 3em'>##TAGLIST##</p>

        <p style='text-align: center'><!--#exec cmd="/usr/bin/perl /disk01/www/html/main/images/etc/random-images.pl" --></p>

		<h2>Sets</h2>
		<p style='text-align: center; margin-left: 3em; margin-right: 3em'>##SETLIST##</p>
		
        <p style='text-align: center'><!--#exec cmd="/usr/bin/perl /disk01/www/html/main/images/etc/random-images.pl" --></p>
		
		<hr />
		<p>Creator: Eric Lease Morgan &lt;<a href="mailto:eric_morgan\@infomotions.com">eric_morgan\@infomotions.com</a>&gt;<br />
		Date created: 2001-01-01<br />
		Date updated: 2010-05-22<br />
		URL: <a href="http://infomotions.com/images/">http://infomotions.com/images/</a></p>
		</div>
	</div>
</body>
</html>
EOF

}