#!/usr/bin/perl -w

# ldap.pl - query the ldap server

# Eric Lease Morgan <emorgan@nd.edu>

# June 13, 2008 - added department
# June 5, 2008 - second cut; refinements added a la Derek Owens, "Thanks!"


# require
use strict;
use Net::LDAP;

# initialize
foreach ( &search( $ARGV[ 0 ] )) {

	# initialize
	my ( $name, $telephone, $email, $affiliation, $title, $uid, $department ) = split "\t", $_;
	
	# build the detail
	my $detail = "http://eds.nd.edu/cgi-bin/nd_ldap_search.pl?ldapfilter=uid=$uid";
	
	# display
	print "         Name: $name\n";
	print "    Telephone: $telephone\n";
	print "        Email: $email\n";
	print "  Affiliation: $affiliation\n";
	print "        Title: $title\n";
	print "          UID: $uid\n";
	print "       Detail: $detail\n";
	print "   Department: $department\n";
	print "\n";
	
}

# done
exit;

sub search {

	my $query = $_[ 0 ];
	
	# connectd and bind
	my $ldap = Net::LDAP->new( 'directory.nd.edu' ) or die "$@";
	my $mesg = $ldap->bind;
	
	# search
	$mesg = $ldap->search(
	
		base   => "o=University of Notre Dame,st=Indiana,c=US",
		filter => "cn=*$query*",
		attrs  => [ 'displayName', 'telephoneNumber', 'mail', 'ndprimaryaffiliation', 'title', 'uid', 'ndtoplevelprimarydepartment' ]
		
	);
	
	# sanity check
	$mesg->code && die $mesg->error;
	
	# echo
	#foreach my $entry ($mesg->entries) { $entry->dump; }

	# process each result
	my @results;
	foreach my $entry ($mesg->entries) {
	
		my $name        = $entry->get_value( 'displayName' )                 ? $entry->get_value( 'displayName' )                 : '';
		my $phone       = $entry->get_value( 'telephoneNumber' )             ? $entry->get_value( 'telephoneNumber' )             : '';
		my $email       = $entry->get_value( 'mail' )                        ? $entry->get_value( 'mail' )                        : '';
		my $affiliation = $entry->get_value( 'ndprimaryaffiliation' )        ? $entry->get_value( 'ndprimaryaffiliation' )        : '';
		my $title       = $entry->get_value( 'title' )                       ? $entry->get_value( 'title' )                       : '';
		my $uid         = $entry->get_value( 'uid' )                         ? $entry->get_value( 'uid' )                         : '';
		my $department  = $entry->get_value( 'ndtoplevelprimarydepartment' ) ? $entry->get_value( 'ndtoplevelprimarydepartment' ) : '';
		
		push @results, "$name\t$phone\t$email\t$affiliation\t$title\t$uid\t$department\r";
		
	}
	
	# cleanup and quit
	$mesg = $ldap->unbind;
	
	return @results;

}
